#pragma once

#include "Config.h"
#include "FileDB.h"
#include "afxtempl.h"
///////////////////////////////////////////////////////////////////////////////
#define kCfgEventSignalChange			4000
#define kCfgEventRegStateChange			4001
///////////////////////////////////////////////////////////////////////////////
/*File Name for preferred and availabl networks*/
#define kAvailableNwkFileName			"AvailableNwkDB"
#define kPreferredNwkFileName			"PreferredNtwDB"

#define	kNwkNumberPrefKey				"NumPref"
#define	kNwkNumberAvailableKey			"NumAvailable"
#define	kNwkIdKey						"Id"
#define kNwkStateKey					"Stat"
#define	kNwkLongNameKey					"LName"
#define	kNwkShortNameKey				"SName"
#define	kNwkSimIndexKey					"SimIndex"
#define	kNwkFormatKey					"Fmt"
#define kNwkPrefOpMaxKey				"PrefOpMax"
#define kNwkAvailableOpMaxKey			"AvailableOpMax"

#define	kNwkDefaultNbAvailableNet		4
#define kNwkDefaultState				kTelNwkNetworkAvailableState
#define	kNwkDefaultSimIndex				0
#define kNwkDefaultPrefOpMax			20

#define	kNwkDefaultPreferredNum			6

#define kNwkLongNameSize				(24 + 1)
#define kNwkShortNameSize				(7 + 1)


/*Network Section in the regular DB file*/
#define kNwkSection						"NWK"

/*Keys*/
#define kNwkSignalLevelKey				"SignalLevel"
#define	kNwkRegStateKey					"RegStat"
#define	kNwkNotifEnableKey				"NotifEnable"
#define	kNwkSearchModeKey				"SearchMd"
#define	kNwkServerStateKey				"SrvStat"

/*Values*/
//Search mode
#define kTelNwkManualSearch				1
#define kTelNwkAutoSearch				0
//REG notif mode
#define kNwkRegNotifDisabled			0
#define kNwkRegNotifEnabled				1
#define kNwkRegLocalInfoNotifEnabled	2
//REG state
#define kTelNwkNotRegMeNotSearching		0
#define kTelNwkNotRegMeIsSearching		2
#define kTelNwkRegistered				1	
#define kTelNwkRegisterDenied			3
#define kTelNwkRegisterUknown			4
#define kTelNwkRegisteredRoaming		5
//mSrvState
#define kTelNwkFullService				0
#define kTelNwkLimitedService			1
#define kTelNwkNoService				2
#define kTelNwkSetRegistrationModeOnly	3

/*Default values*/
#define kNwkDefaultSignalLevel				15
#define	kNwkDefaultNotifEnable			kNwkRegLocalInfoNotifEnabled
#define	kNwkDefaultSearchMode			kTelNwkAutoSearch
#define	kNwkDefaultRegState				kTelNwkRegistered
#define	kNwkDefaultServerState			kTelNwkFullService
#define kNwkDefaultNetNameFormat		kLongNameFormat

/*Unknown*/
#define kNwkShortNameSize				(7 + 1)
#define kNwkLongNameSize				(24 + 1)

#define kTelNwkNetworkUknownState		0
#define kTelNwkNetworkAvailableState	1
#define kTelNwkNetworkCurrentState		2
#define kTelNwkNetworkForbidenState		3

/*Cell and area code*/
#define	kCellIdStrLength				4
#define	kAreaCdStrLength				4
#define	kNwkCellIdKey					"CellId"
#define	kNwkAreaCodeKey					"AreaCd"
#define	kNwkDefaultCellId				"00AD"
#define	kNwkDefaultAreaCode				"00C3"

/*Network name presentation*/
#define kLongNameFormat					0
#define kShortNameFormat				1
#define kNumericNameFormat				2
///////////////////////////////////////////////////////////////////////////////

typedef struct _networksType
{
	UInt16	mcc;							// MCC Mobile country code
	UInt16	mnc;							// MNC Mobile network code
	char		shortName[kNwkShortNameSize];	// network name
	char		longName[kNwkLongNameSize];		// network name
	
} networksType;
/////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CNwkDesc
{
public:
	CNwkDesc();
	UInt16  mSimIndex;
	UInt32	mNumericName;
	char	mLongName[kNwkLongNameSize];
	char	mShortName[kNwkShortNameSize];
	UInt16	mState;
	
};
///////////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API CConfigNWK : public CConfig
{
protected:
	UInt32 PrvGetNwkId(UInt32 nwkIndex);
	//void FreeAllocatedParams();

	UInt8	mNwkFormat;
	UInt8	mSignalLevel;
	UInt8	mNotifEnable;
	Bool	mSearchMode;
	UInt8	mRegState;	
	int		mCurNetIndex;
	CString	mCellId;//[kCellIdStrLength + 1];
	CString	mAreaCode;//[kAreaCdStrLength + 1];

	// Available Networks	
	UInt32		mAvailableCurrentNwkIndex;
	UInt16		mNbAvailableNwk;
	CList<CNwkDesc, CNwkDesc> mAvailableNwkDesc;
	int			mAvailableOpMax;

	// Preferred Networks	
	UInt16		mNbPreferredNwk;
	UInt8		mPreferredNwkStat;
	CList<CNwkDesc, CNwkDesc&> mPreferredNwkDesc;
	int			mPrefOpMax;

	//All networks
	CList<networksType, networksType&> networksList;

public:
	CConfigNWK() {};
	CConfigNWK(CDllManager* iDllManager);
	~CConfigNWK();
	virtual Bool Load();
	virtual Bool Save();
	virtual void DeleteSection();

	UInt8	GetSignalStrength();
	void	SetSignalStrength(UInt8 iSignalLevel);
	UInt8	GetNotifCtr();
	void	SetNotifCtr(UInt8 iNotifAnable);
	Bool	GetSearchMode();
	void	SetSearchMode(Bool iSearchMode);
	UInt8	GetRegState();
	void	SetRegState(UInt8 iRegState);
	void	GetCellId(CString* ioCellId);
	void	SetCellId(CString iCellId);
	void	GetAreaCode(CString* ioAreaCode);
	void	SetAreaCode(CString iAreaCode);
	UInt8	GetNetNameFormat();
	void	SetNetNameFormat(UInt8 iFormat);
	int		GetPrefOpMax();
	void	SetPrefOpMax(int iMax);
	int		GetAvailableOpMax();
	void	SetAvailableOpMax(int iMax);

	void	SetPreferredNwkDesc(CList<CNwkDesc, CNwkDesc&> *iPreferredNwkDesc);
	void	GetPreferredNwkDesc(CList<CNwkDesc, CNwkDesc&> *ioPrefList);	

	void	SetAvailCurNwkIndex(UInt32 iAvailCurrentNwkIndex);
	UInt32	GetAvailCurNwkIndex();
	void	SetAvailNwkDesc(CList<CNwkDesc, CNwkDesc&> *iAvailableNetDesc);
	void	GetAvailNwkDesc(CList<CNwkDesc, CNwkDesc&> *iAvailList);

	void	GetAllNwkList(CList<networksType, networksType&> *ioAllList);
	
	virtual void SendCREGNotif();
};
///////////////////////////////////////////////////////////////////////////////

static networksType networks[] =
/*  MCC     MNC     ABBR       FULL NAME                     */
/*{ 0xNNNN, 0xNNNN, "xxxxxxx", "xxxxxxxxxxxxxxxxxxxxxxxxx" },*/
{
  { 0x0202, 0x0001, "C-OTE",   "COSMOTE"                   }, /* DCS1800 */
  { 0x0202, 0x0005, "PAN",     "PANAFON"                   },
  { 0x0202, 0x0010, "TLSTET",  "TELESTET"                  },

  { 0x0204, 0x0004, "LIBTEL",  "LIBERTEL"                  },
  { 0x0204, 0x0008, "PTT",     "PTT TELECOM"               },
  { 0x0204, 0x0012, "TELFRT",  "TELFORT"                   },

  { 0x0206, 0x0001, "PROXI",   "PROXIMUS"                  },
  { 0x0206, 0x0010, "mobi*",   "mobistar"                  },

  { 0x0208, 0x0001, "Itine",   "Itineris"                  },
  { 0x0208, 0x0010, "SFR",     "SFR"                       },
  { 0x0208, 0x0020, "BYTEL",   "BOUYGUES TELECOM"          }, /* DCS1800 */

  { 0x0213, 0x0003, "M-AND",   "MOBILAND"                  },

  { 0x0214, 0x0001, "AIRTL",   "AIRTEL"                    },
  { 0x0214, 0x0003, "AMENA",   "AMENA"                     },
  { 0x0214, 0x0007, "MSTAR",   "MOVISTAR"                  },

  { 0x0216, 0x0001, "PANNON",  "PANNON GSM"                },
  { 0x0216, 0x0030, "W-900",   "WESTEL 900"                },

  { 0x0218, 0x0090, "BHGSM",   "GSMBIH"                    },

  { 0x0219, 0x0001, "CRON",    "CRONET"                    },

  { 0x0220, 0x0001, "MOBTEL",  "MOBTEL"                    },

  { 0x0222, 0x0001, "TIM",     "TELECOM ITALIA MOBILE"     },
  { 0x0222, 0x0010, "OMNI",    "OMNITEL"                   },
  { 0x0222, 0x0020, "BTEL",    "BLUTEL"                    },
  { 0x0222, 0x0088, "WIND",    "Wind"                      },

  { 0x0226, 0x0001, "CONNEX",  "CONNEX GSM"                },
  { 0x0226, 0x0010, "dialog",  "dialog"                    },

  { 0x0228, 0x0001, "SWISS",   "SWISS GSM"                 }, /* DCS1800 & GSM900 */
  { 0x0228, 0x0002, "diAx",    "diAx Mobile AG"            },

  { 0x0230, 0x0001, "PAEGAS",  "PAEGAS"                    },
  { 0x0230, 0x0002, "ET-CZ",   "EUROTEL"                   },

  { 0x0231, 0x0001, "SVK GT",  "GLOBTEL"                   },
  { 0x0231, 0x0002, "ET-SK",   "EUROTEL GSM"               },

  { 0x0232, 0x0001, "A1",      "A1"                        },
  { 0x0232, 0x0003, "max.",    "max.mobil."                },

  { 0x0234, 0x0010, "CLNET",   "CELLNET"                   },
  { 0x0234, 0x0015, "VODA",    "VODAFONE"                  },
  { 0x0234, 0x0030, "ONE2ONE", "MERCURY ONE-2-ONE"         }, /* DCS1800 */
  { 0x0234, 0x0033, "ORANGE",  "ORANGE"                    }, /* DCS1800 */
  { 0x0234, 0x0050, "JT-GSM",  "JERSEY TELECOMS GSM"       },
  { 0x0234, 0x0055, "GSY-TEL", "GUERNSEY TELECOMS GSM"     }, /* "GUERNSEY TEL %c" */
  { 0x0234, 0x0058, "MANX",    "PRONTO GSM"                }, /* "MANX TELECOM &p" */

  { 0x0238, 0x0001, "TD MOB",  "TDK-MOBIL"                 },
  { 0x0238, 0x0002, "SONO",    "SONOFON"                   },
  { 0x0238, 0x0020, "TELIA",   "TELIA DK"                  }, /* DCS1800 */
  { 0x0238, 0x0030, "#mbix",   "mobilix"                   }, /* DCS1800 */

  { 0x0240, 0x0001, "TELIA",   "TELIA MOBILE"              }, /* DCS1800 & GSM900 */
  { 0x0240, 0x0007, "IQ",      "COMVIQ"                    },
  { 0x0240, 0x0008, "EURO",    "EUROPOLITAN"               }, /* DCS1800 & GSM900 */

  { 0x0242, 0x0001, "TELENOR", "TELENOR"                   },
  { 0x0242, 0x0002, "COM",     "NetCom GSM"                },

  { 0x0244, 0x0003, "TELIA",   "TELIA"                     }, /* DCS1800 */
  { 0x0244, 0x0005, "RL",      "RADIOLINJA"                },
  { 0x0244, 0x0009, "FINNET",  "FINNET"                    }, /* DCS1800 */
  { 0x0244, 0x0091, "SONERA",  "SONERA"                    }, /* DCS1800 & GSM900 */

  { 0x0246, 0x0001, "OMT",     "OMNITEL"                   },
  { 0x0246, 0x0002, "BITE",    "BITE GSM"                  },

  { 0x0247, 0x0001, "LMT",     "LMT GSM"                   },
  { 0x0247, 0x0002, "B-COM",   "BALTCOM GSM"               },

  { 0x0248, 0x0001, "EMT",     "EMT GSM"                   },
  { 0x0248, 0x0002, "RLE",     "RADIOLINJA EESTI"          },
  { 0x0248, 0x0003, "Q GSM",   "Q GSM"                     },

  { 0x0250, 0x0001, "MTS",     "MTS"                       },
  { 0x0250, 0x0002, "NWGSM",   "North-West"                },
  { 0x0250, 0x0005, "SCS",     "Siberian Cellular 900"     },	/* "Siberian Cellular Systems 900" */
  { 0x0250, 0x0012, "FEast",   "Far Eastern Cellular 900"  },	/* "Far Eastern Cellular Systems - 900" */
  { 0x0250, 0x0013, "KUGSM",   "Kuban-GSM"                 },
  { 0x0250, 0x0039, "UTL",     "Uraltel"                   },

  { 0x0255, 0x0001, "UMC",     "UMC"                       },
  { 0x0255, 0x0002, "FLASH",   "FLASH"                     },
  { 0x0255, 0x0003, "KS",      "KYIVSTAR"                  },
  { 0x0255, 0x0005, "GT-BCS",  "GOLDEN TELECOM"            }, /* DCS1800 */

  { 0x0260, 0x0001, "PLUS",    "Plus GSM"                  },
  { 0x0260, 0x0002, "ERAGSM",  "ERA GSM"                   },
  { 0x0260, 0x0003, "IDEA",    "IDEA Centertel"            },

  { 0x0262, 0x0001, "D1",      "Telekom Mobilfunk D1"      },
  { 0x0262, 0x0002, "D2",      "D2 PRIVAT"                 },
  { 0x0262, 0x0003, "E-Plus",  "E-Plus"                    }, /* DCS1800 */

  { 0x0266, 0x0001, "GIBTEL",  "GIBTEL"                    },

  { 0x0268, 0x0001, "TLCL",    "TELECEL"                   },
  { 0x0268, 0x0003, "OPTIM",   "OPTIMUS"                   },
  { 0x0268, 0x0006, "TMN",     "TMN"                       },

  { 0x0270, 0x0001, "LUXGSM",  "LUXGSM"                    },
  { 0x0270, 0x0077, "TANGO",   "TANGO"                     },

  { 0x0272, 0x0001, "E-GSM",   "EIRCELL-GSM"               },
  { 0x0272, 0x0002, "DIGI",    "Esat Digifone"             },

  { 0x0274, 0x0001, "SIMINN",  "LANDSSIMINN"               },
  { 0x0274, 0x0002, "TAL",     "TAL"                       },

  { 0x0276, 0x0001, "A M C",   "A M C MOBIL"               },

  { 0x0278, 0x0001, "VODA M",  "Vodafone Malta"            },

  { 0x0280, 0x0001, "CY-GSM",  "CYTAGSM"                   },

  { 0x0282, 0x0001, "GCELL",   "GEOCELL"                   },
  { 0x0282, 0x0002, "MAGTI",   "MAGTI GSM"                 },

  { 0x0283, 0x0001, "ARMMO1",  "ARMGSM"                    },

  { 0x0284, 0x0001, "M-TEL",   "M-TEL GSM"                 },

  { 0x0286, 0x0001, "TCELL",   "PTT/TURKCELL"              },
  { 0x0286, 0x0002, "TLSIM",   "PTT TELSIM"                },

  { 0x0293, 0x0041, "SI-GSM",  "MOBITEL"                   },

  { 0x0294, 0x0001, "MOBI-M",  "MOBIMAK"                   },

  { 0x0302, 0x0037, "MCELL",   "Microcell Connexions"      }, /* PCS1900 */

/* "Wireless 2000 Telephone Company"   Too Long */
  { 0x0310, 0x0011, "WTTCKy",  "Wireless 2000"             }, /* PCS1900 */
  { 0x0310, 0x0031, "AERIAL",  "AERIAL"                    }, /* PCS1900 */
  { 0x0310, 0x0150, "BSMDCS",  "BellSouth Mobility DCS"    }, /* PCS1900 */
  { 0x0310, 0x0200, "WWC",     "VOICESTREAM"               }, /* PCS1900 */
  { 0x0310, 0x0210, "WWC",     "VOICESTREAM"               }, /* PCS1900 */
  { 0x0310, 0x0220, "WWC",     "VOICESTREAM"               }, /* PCS1900 */
  { 0x0310, 0x0230, "WWC",     "VOICESTREAM"               }, /* PCS1900 */
  { 0x0310, 0x0240, "WWC",     "VOICESTREAM"               }, /* PCS1900 */
  { 0x0310, 0x0250, "WWC",     "VOICESTREAM"               }, /* PCS1900 */
  { 0x0310, 0x0260, "WWC",     "VOICESTREAM"               }, /* PCS1900 */
  
  { 0x0310, 0x0270, "USA27",   "Powertel PCS Partners"     }, /* PCS1900 */ /* "%c Powertel, Inc." */

  { 0x0340, 0x0001, "AMERIS",  "AMERIS"                    },

  { 0x0400, 0x0001, "ACELL",   "AZERCELL"                  },

  { 0x0404, 0x0001, "ESSARH",  "ESSAR CELLPHONE"           },
  { 0x0404, 0x0007, "TATA",    "TATA CELLULAR"             },
  { 0x0404, 0x0010, "AIRTL",   "AirTel"                    },
  { 0x0404, 0x0011, "ESSAR",   "ESSAR CELLPHONE"           },
  { 0x0404, 0x0012, "ESCOTL",  "ESCOTEL"                   },
  { 0x0404, 0x0014, "MODICO",  "MODICOM"                   },
  { 0x0404, 0x0015, "ESSARU",  "ESSAR CELLPHONE"           },
/*{ 0x0404, 0x0019, "ESCOTL",  "ESCOTEL"                   }, removed FR9811-3289 */
  { 0x0404, 0x0020, "MAXTCH",  "MaxTouch"                  },
  { 0x0404, 0x0021, "BPL MO",  "BPL MOBILE"                }, /* "BPL MOBIL" */
  { 0x0404, 0x0027, "BPL MO",  "BPL USWEST (Maharastra)"   }, /* "BPL MOBIL" "BPL USWEST Cellular (Maharastra)" */
  { 0x0404, 0x0030, "COMMND",  "COMMAND"                   },
  { 0x0404, 0x0041, "RPG",     "RPG Cellular"              },
  { 0x0404, 0x0043, "BPL MO",  "BPL USWEST (Tamil Nadu)"   }, /* "BPL USWEST Cellular (Tamil Nadu)" */
  { 0x0404, 0x0046, "BPL MO",  "BPL USWEST (Kerala)"       }, /* "BPL USWEST Cellular (Kerala)" */
/*{ 0x0404, 0x0056, "ESCOTL",  "ESCOTEL"                   }, removed FR9811-3289 */
  { 0x0404, 0x0060, "ESSARR",  "ESSAR CELLPHONE"           },

  { 0x0413, 0x0002, "DIALOG",  "DIALOG"                    },

  { 0x0415, 0x0001, "CLLIS",   "Cellis"                    },
  { 0x0415, 0x0003, "LibCL",   "LibanCell"                 },

  { 0x0416, 0x0001, "FSTLNK",  "Fastlink"                  },

  { 0x0417, 0x0009, "MOBILE",  "MOBILE SYRIA"              },

  { 0x0419, 0x0002, "MTC",     "MTCNet"                    },

  { 0x0420, 0x0001, "KSA",     "MoPTT,DMTS-1"              },
  { 0x0420, 0x0007, "EAE",     "EAE-ALJAWWAL"              },

  { 0x0422, 0x0002, "O-MOBI",  "OMAN MOBILE"               },

  { 0x0424, 0x0002, "ETSLT",   "ETISALAT"                  },

  { 0x0426, 0x0001, "M.PLUS",  "MOBILE PLUS"               },

  { 0x0427, 0x0001, "Q-NET",   "QATARNET"                  },

  { 0x0434, 0x0004, "DW-GSM",  "DAEWOO"                    },
  { 0x0434, 0x0005, "COSCOM",  "COSCOM"                    },

  { 0x0437, 0x0005, "BITEL",   "BITEL"                     },

  { 0x0452, 0x0001, "MOBIF",   "Mobi Fone"                 },

  { 0x0454, 0x0000, "TELCO",   "HK TELECOM"                },
  { 0x0454, 0x0004, "HTCL",    "HTCLGSM"                   }, /* DCS1800 & GSM900 */
  { 0x0454, 0x0006, "HKSMC",   "SMARTONE"                  },
  { 0x0454, 0x0010, "NWT",     "New World Telephone"       }, /* DCS1800 */
  { 0x0454, 0x0012, "PTC",     "PEOPLES"                   }, /* DCS1800 */
  { 0x0454, 0x0016, "SUNDAY",  "SUNDAY"                    }, /* DCS1800 */
  { 0x0454, 0x0018, "P-LINK",  "PACIFIC LINK"              }, /* DCS1800 */
/*{ 0x0454, 0x0020, "HTL",     "HUTCHISON"                 }, removed FR9811-3289 */
  { 0x0454, 0x0022, "P PLUS",  "P PLUS"                    }, /* DCS1800 */

  { 0x0455, 0x0001, "CTMGSM",  "TELEMOVEL+"                },

  { 0x0456, 0x0001, "MT-KHM",  "MOBITEL"                   },

  { 0x0460, 0x0000, "CT-GSM",  "CHINA TELECOM GSM"         }, /* "CHINA TELECOM" */
  { 0x0460, 0x0001, "CU-GSM",  "CHINA UNICOM GSM"          },

  { 0x0466, 0x0001, "FET",     "Far EasTone"               },
  { 0x0466, 0x0006, "TUNTEX",  "Tuntex 1800"               }, /* DCS1800 */
  { 0x0466, 0x0088, "KGT",     "KG Telecom"                }, /* DCS1800 */
  { 0x0466, 0x0092, "LDGSM",   "LDTA GSM"                  },
  { 0x0466, 0x0093, "TW MOB",  "MOBITAI"                   },
  { 0x0466, 0x0097, "PCC",     "Pacific GSM 1800"          }, /* DCS1800 */

  { 0x0470, 0x0001, "GP",      "GrameenPhone"              },

  { 0x0502, 0x0012, "maxis",   "maxis mobile"              },
  { 0x0502, 0x0013, "MRTEL",   "EMARTEL"                   },
  { 0x0502, 0x0016, "MT18",    "DIGI 1800"                 }, /* DCS1800 */
  { 0x0502, 0x0017, "ADAM",    "ADVANCED DIGITAL ACCESS"   }, /* "ADVANCED DIGITAL ACCESS MOBILES" */
  { 0x0502, 0x0019, "CELCOM",  "CELCOM GSM"                },

  { 0x0505, 0x0001, "M-NET",   "MOBILENET"                 },
  { 0x0505, 0x0002, "Optus",   "YES OPTUS"                 },
  { 0x0505, 0x0003, "VFONE",   "VODAFONE"                  },

  { 0x0510, 0x0001, "SAT-C",   "IND SATELINDOCEL"          },
  { 0x0510, 0x0010, "T-SEL",   "TELKOMSEL"                 },
  { 0x0510, 0x0011, "EXCEL",   "EXCELCOM"                  },

  { 0x0515, 0x0001, "ISLA",    "Islacom"                   },
  { 0x0515, 0x0002, "GLOBE",   "Globe Telecom"             },

  { 0x0520, 0x0001, "TH AIS",  "AIS GSM"                   },
  { 0x0520, 0x0010, "TH WCS",  "WCS"                       }, /* DCS1800 */
  { 0x0520, 0x0023, "HELLO",   "Digital Phone Co. Ltd"     }, /* DCS1800 */

  { 0x0525, 0x0001, "STGSM",   "ST-GSM"                    },
  { 0x0525, 0x0002, "GSM1800", "ST-GSM-1800"               }, /* DCS1800 */
  { 0x0525, 0x0003, "M1-GSM",  "M1-GSM"                    },

  { 0x0528, 0x0011, "DSTCom",  "DSTCom"                    },

  { 0x0530, 0x0001, "BSNZ",    "BELLSOUTH"                 },

  { 0x0542, 0x0001, "VODAFJ",  "VODAFONE"                  },

  { 0x0546, 0x0001, "MOBNCL",  "MOBILIS"                   },

  { 0x0547, 0x0020, "VINI",    "VINI"                      },

  { 0x0604, 0x0001, "IAM",     "IAM"                       },

  { 0x0612, 0x0003, "Ivoir",   "Ivoiris"                   },
  { 0x0612, 0x0005, "TELCEL",  "TELCEL"                    },

  { 0x0617, 0x0001, "CELL +",  "CELLPLUS"                  },

  { 0x0620, 0x0001, "SPACE",   "SPACEFON"                  },

  { 0x0624, 0x0001, "CAMNET",  "CAM CELLNET"               },

  { 0x0625, 0x0001, "CMOVEL",  "CVMOVEL"                   },

  { 0x0633, 0x0001, "SEYCEL",  "CELLULAR SERVICES"         }, /* "SEYCHELLES CELLULAR SERVICES" */
  { 0x0633, 0x0010, "AIRTEL",  "AIRTEL"                    },

  { 0x0634, 0x0001, "SD-MOB",  "MobiTel"                   },

  { 0x0635, 0x0010, "RCELL",   "Rwandacell"                },

  { 0x0636, 0x0001, "ET-MTN",  "ETMTN"                     },

  { 0x0640, 0x0001, "TRITEL",  "TRI - TELECOMMUNICATION"   }, /* "TRI - TELECOMMUNICATION (T) LTD" */

  { 0x0641, 0x0010, "MTN-UG",  "MTN-UGANDA"                },

  { 0x0642, 0x0002, "ANTARI",  "ANTARIS"                   },

  { 0x0643, 0x0001, "mCel",    "mCel"                      },

  { 0x0647, 0x0010, "SFR RU",  "SFR REUNION"               },

  { 0x0648, 0x0001, "NET*1",   "NET*ONE"                   },

  { 0x0650, 0x0001, "CP 900",  "CALLPOINT 900"             },

  { 0x0651, 0x0001, "VCLCOM",  "VODACOM LESOTHO"           },

  { 0x0655, 0x0001, "VODA",    "VodaCom"                   },
  { 0x0655, 0x0010, "MTN",     "Mobile Telephone Network"  }, /* "MTN - Mobile Telephone Network Ltd" */

  { 0x0730, 0x0001, "ENTEL",   "ENTEL TELEFONIA MOVIL"     },	/* PCS1900 */
  { 0x0730, 0x0010, "ENTEL",   "ENTEL PCS"                 },	/* PCS1900 */

  { 0x0734, 0x0001, "INFONT",  "INFONET"                   },

  /* NULL record indicates the end of the list */
  { 0x0000, 0x0000, "",        ""                          }
};
